#!/bin/sh

TP_MENU_OK_CANCEL_RESULT_NULL="DTAS[TUI]@{NULL}"
TP_MENU_OK_CANCEL_RESULT_SELECT=""

TP_MENU_OK_CANCEL_RESULT_OK="DTAS[TUI]@{OK}"
TP_MENU_OK_CANCEL_RESULT_CANCEL="DTAS[TUI]@{CANCEL}"
TP_MENU_OK_CANCEL_RESULT_ERROR="DTAS[TUI]@{ERROR}"
TP_MENU_OK_CANCEL_RESULT_CODE=""

TP_MENU_OK_CANCEL_RESULT_MSG=""

tp_menu_ok_cancel() {
    #debug_print "${0}" "${LINENO}" 'in function "tp_menu_ok_cancel"'
    
	local title="${1}"
	local text="${2}"
	local ok_label="${3}"
    local cancel_label="${4}"
    local menu_list="${5}"
	local menu_item_number="${6:-20}"
    local default_item="${7}"

    exec 3>&1
    local ret=`sh -c "dialog \
        --backtitle    \"${CONS_BACK_TITLE}\" \
        --title        \"${title}\" \
        --ok-label     \"${ok_label}\" \
        --cancel-label \"${cancel_label}\" \
        --default-item \"${default_item}\" \
        --menu         \"${text}\" \
                       \"${CONS_BOX_HEIGHT}\" \
                       \"${CONS_BOX_WIDTH}\" \
                       ${menu_item_number} \
                       ${menu_list} \
        2>&1 1>&3"; \
        case "${?}" in \
            1|255) echo "${TP_MENU_OK_CANCEL_RESULT_CANCEL}" ;; \
        esac`
	exec 3>&-
    
    ##################################################
    # press "CANCEL" or "ESC"
    ##################################################
    case "${ret}" in
        "${TP_MENU_OK_CANCEL_RESULT_CANCEL}" )
            TP_MENU_OK_CANCEL_RESULT_CODE="${TP_MENU_OK_CANCEL_RESULT_CANCEL}"
            TP_MENU_OK_CANCEL_RESULT_SELECT="${TP_MENU_OK_CANCEL_RESULT_NULL}"
            TP_MENU_OK_CANCEL_RESULT_MSG=""
            return
            ;;
    esac

    TP_MENU_OK_CANCEL_RESULT_CODE="${TP_MENU_OK_CANCEL_RESULT_OK}"
    TP_MENU_OK_CANCEL_RESULT_SELECT="${ret}"
    TP_MENU_OK_CANCEL_RESULT_MSG=""
    return
}

